<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('inventarios', function (Blueprint $table) {
            $table->id();
            $table->string('ubicacion')->nullable();
            $table->string('marca')->nullable();
            $table->string('servicio')->nullable();
            $table->string('nombre')->nullable();
            $table->string('riesgo')->nullable();
            $table->string('comercio')->nullable();
            $table->string('modelo')->nullable();
            $table->string('serie')->nullable();
            $table->string('placa')->nullable();
            $table->string('foto')->nullable();
            $table->string('modalidad')->nullable();
            $table->string('qr')->nullable();
            $table->foreignId('subcategoria_id')
            ->references('id')
            ->on('subcategorias')
            ->onDelete('cascade');
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('inventarios');
    }
};
