<?php

namespace Database\Factories;

use App\Models\equipos;
use App\Models\sede;
use App\Models\servicios;
use App\Models\terceros;
use App\Models\ubicaciones;
use App\Models\zonas;
use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\inventario>
 */
class InventarioFactory extends Factory
{
    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        return [
            'codigo' => fake()->companySuffix(),
            'carpeta' => fake()->name(),
            'marca' => fake()->company(),
            'modelo' => fake()->windowsPlatformToken(),
            'serie' => fake()->phoneNumber(),
            'placa' => fake()->randomDigitNotZero(),
            'invima' => fake()->randomDigitNotZero(),
            'modalidad' => fake()->languageCode(),
            'mto' => fake()->name(),
            'riesgo' => fake()->name(),
            'mtto' => fake()->randomDigitNotZero(),
            'calibracion' => fake()->randomDigitNotZero(),
            'instalacion' => fake()->dateTime(),
            'sede_id' => sede::factory(),
            'zona_id' => zonas::factory(),
            'equipo_id' => equipos::factory(),
            'ubicacion_id' => ubicaciones::factory(),
            'servicio_id' => servicios::factory(),
            'tercero_id' => terceros::factory(),
        ];
    }
}
