<?php

use Illuminate\Foundation\Application;
use Illuminate\Foundation\Configuration\Exceptions;
use Illuminate\Foundation\Configuration\Middleware;

return Application::configure(basePath: dirname(__DIR__))
    ->withRouting(
        web: __DIR__.'/../routes/web.php',
        commands: __DIR__.'/../routes/console.php',
        health: '/up',
    )
    ->withMiddleware(function (Middleware $middleware) {
        $middleware->validateCsrfTokens(except: [
            'inventario/*',
            'inventario',
            'ginventario/*',
            'ginventario',
            'getData',
            'getDataG',
            'getCat',
            'getCatG',
            'crearQrs',
            'crearQrsG',
            'importData',
            'importDataCronos',
            'importDataG',
            'categorias/*',
            'subcategorias/*',
            'categorias',
            'gsubcategorias',
            'subcategorias',
            'gcategorias/*',
            'gsubcategorias/*',
            'gcategorias',
            'sedes/*',
            'cronogramas/*',
            'archivos/*',
            'garchivos/*',
            'sedes',
            'archivos',
            'garchivos',
            'cronogramas',
            'gsedes/*',
            'gsedes',
            'obtenerEstadisticas',
            'exportBase',
            'exportBaseG',
            'downloadQr',
            'downloadQrG',
        ]);
    })
    ->withExceptions(function (Exceptions $exceptions) {
        //
    })->create();
