<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Notifications\Notifiable;

class sede extends Model
{
    use HasFactory, Notifiable, SoftDeletes;
    protected $fillable = [
        'nombre',
    ];

    public function sede(): HasMany{
        return $this->HasMany(inventario::class,'id','sede_id');
    }

    public function categorias()
    {
        return $this->hasMany(categorias::class, 'sede_id');
    }
}
