<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Notifications\Notifiable;

class categorias extends Model
{
    use HasFactory, Notifiable, SoftDeletes;
    protected $fillable = [
        'nombre',
        'color',
        'general',
        'sede_id'
    ];

    public function sede()
    {
        return $this->belongsTo(Sede::class, 'sede_id');
    }

    public function subcategorias()
    {
        return $this->hasMany(subcategorias::class, 'categoria_id');
    }
}
