<?php

namespace App\Http\Controllers;

use App\Models\Garchivos;
use App\Http\Controllers\Controller;
use App\Http\Requests\StoreGarchivosRequest;
use App\Http\Requests\UpdateGarchivosRequest;
use Illuminate\Http\Request;

class GarchivosController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index(Request $request)
    {
        $query = Garchivos::query();
        
        if ($request->has('tipo')) {
            $query->where('tipo', $request->tipo);
        }
        
        $archivos = $query->get();
        foreach ($archivos as $archivo) {
            $archivo->inventario;
        }
        return response()->json($archivos, 200);
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        //
    }

    public function download(Request $request)
    {
        $archivo = Garchivos::firstWhere("id", $request->id);
        return response()->download(public_path($archivo->archivo));
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(StoreGarchivosRequest $request)
    {
        try {
            $request->validate([
                'file' => 'required|file|max:10240', // máximo 10MB
                'tipo' => 'nullable|string', // validación para el tipo
            ]);

            $archivo = new Garchivos();

            if ($request->hasFile('file')) {
                $file = $request->file('file');
                $fileName = time() . '_' . $file->getClientOriginalName();
                $file->move(public_path('uploads/general/archivos'), $fileName);
                $archivo->archivo = 'uploads/general/archivos/' . $fileName;
                $archivo->inventario_id = $request->id;
                $archivo->tipo = $request->tipo; // Agregamos el tipo
            }

            $archivo->saveOrFail();
            return response()->json([
                'message' => 'Archivo subido exitosamente',
                'file' => $archivo
            ], 201);
        } catch (\Exception $exception) {
            return response()->json(['message' => $exception->getMessage()], 500);
        }
    }

    /**
     * Display the specified resource.
     */
    public function show(Garchivos $garchivo)
    {
        $garchivo->inventario;
        return response()->json($garchivo, 200);
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(Garchivos $garchivos)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(UpdateGarchivosRequest $request, Garchivos $garchivo)
    {
        try {
            $request->validate([
                'file' => 'required|file|max:10240', // máximo 10MB
            ]);

            if ($request->hasFile('file')) {
                // Eliminar archivo anterior si existe
                if ($garchivo->archivo && file_exists(public_path($garchivo->archivo))) {
                    unlink(public_path($garchivo->archivo));
                }

                $file = $request->file('file');
                $fileName = time() . '_' . $file->getClientOriginalName();
                $file->move(public_path('uploads/general/archivos'), $fileName);
                $garchivo->archivo = 'uploads/general/archivos/' . $fileName;
            }

            $garchivo->save();
            return response()->json([
                'message' => 'Archivo actualizado exitosamente',
                'file' => $garchivo
            ], 200);
        } catch (\Exception $e) {
            return response()->json(['message' => $e->getMessage()], 500);
        }
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(Garchivos $garchivo)
    {
        try {
            if ($garchivo->archivo && file_exists(public_path($garchivo->archivo))) {
                unlink(public_path($garchivo->archivo));
            }

            $garchivo->delete();
            return response()->json([
                'message' => 'Archivo eliminado exitosamente'
            ], 200);
        } catch (\Exception $e) {
            return response()->json(['message' => $e->getMessage()], 500);
        }
    }
}
