<?php

namespace App\Http\Controllers;

use App\Models\categorias;
use App\Http\Controllers\Controller;
use App\Http\Requests\StorecategoriasRequest;
use App\Http\Requests\UpdatecategoriasRequest;
use Illuminate\Database\Eloquent\ModelNotFoundException;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;

use function Pest\Laravel\json;

class CategoriasController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index($request): JsonResponse
    {
        if ($request == 'all') {
            $categorias = categorias::all();
        } else {
            $categorias = categorias::where('sede_id', $request)->get();
        }
        return response()->json($categorias, 200);
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(StorecategoriasRequest $request): JsonResponse
    {
        try {
            $categoria = new categorias();
            $categoria->fill($request->all());
            $categoria->saveOrFail();
            return response()->json(['message' => 'Categoria agregado exitosamente', 'product' => $categoria], 201);
        } catch (ModelNotFoundException $exception) {
            return response()->json(['message' => $exception->getMessage()], 500);
        }
    }

    /**
     * Display the specified resource.
     */
    public function show(categorias $categoria): JsonResponse
    {
        return response()->json($categoria, 200);
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(categorias $categorias)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(UpdatecategoriasRequest $request, categorias $categoria): JsonResponse
    {
        $categoria->fill($request->all());
        if ($categoria->save()) {
            return response()->json(['data' => $categoria, 'message' => 'La categoria se ha actualizado correctamente'], 200);
        }
        return response()->json(['data' => $categoria, 'message' => 'Ha ocurrido un error al actualizar la categoria'], 500);
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(categorias $categoria)
    {
        $categoria->delete();
        return response()->json(['data' => $categoria, 'message' => 'La categoria se ha eliminado correctamente'], 200);
    }
}
