<?php

namespace App\Http\Controllers;

use App\Models\archivos;
use App\Http\Controllers\Controller;
use App\Http\Requests\StorearchivosRequest;
use App\Http\Requests\UpdatearchivosRequest;
use Illuminate\Http\Request;


class ArchivosController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index(Request $request)
    {
        $query = archivos::query();
        
        if ($request->has('tipo')) {
            $query->where('tipo', $request->tipo);
        }
        
        $archivos = $query->get();
        foreach ($archivos as $archivo) {
            $archivo->inventario;
        }
        return response()->json($archivos, 200);
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        //
    }
    public function download(Request $request)
    {
        $archivo = archivos::firstWhere("id", $request->id);
        return response()->download(public_path($archivo->archivo));
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(StorearchivosRequest $request)
    {
        try {
            $request->validate([
                'file' => 'required|file|max:10240', // máximo 10MB
                'tipo' => 'nullable|string', // validación para el tipo
            ]);

            $archivo = new archivos();

            if ($request->hasFile('file')) {
                $file = $request->file('file');
                $fileName = time() . '_' . $file->getClientOriginalName();
                $file->move(public_path('uploads/archivos'), $fileName);
                $archivo->archivo = 'uploads/archivos/' . $fileName;
                $archivo->inventario_id = $request->id;
                $archivo->tipo = $request->tipo; // Agregamos el tipo
            }

            $archivo->saveOrFail();
            return response()->json([
                'message' => 'Archivo subido exitosamente',
                'file' => $archivo
            ], 201);
        } catch (\Exception $exception) {
            return response()->json(['message' => $exception->getMessage()], 500);
        }
    }

    /**
     * Display the specified resource.
     */
    public function show(archivos $archivo)
    {
        $archivo->inventario;
        return response()->json($archivo, 200);
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(archivos $archivos)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(UpdatearchivosRequest $request, archivos $archivo)
    {
        try {
            $request->validate([
                'file' => 'required|file|max:10240', // máximo 10MB
            ]);

            if ($request->hasFile('file')) {
                // Eliminar archivo anterior si existe
                if ($archivo->archivo && file_exists(public_path($archivo->archivo))) {
                    unlink(public_path($archivo->archivo));
                }

                $file = $request->file('file');
                $fileName = time() . '_' . $file->getClientOriginalName();
                $file->move(public_path('uploads/archivos'), $fileName);
                $archivo->archivo = 'uploads/archivos/' . $fileName;
            }

            $archivo->save();
            return response()->json([
                'message' => 'Archivo actualizado exitosamente',
                'file' => $archivo
            ], 200);
        } catch (\Exception $e) {
            return response()->json(['message' => $e->getMessage()], 500);
        }
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(archivos $archivo)
    {
        try {
            if ($archivo->archivo && file_exists(public_path($archivo->archivo))) {
                unlink(public_path($archivo->archivo));
            }

            $archivo->delete();
            return response()->json([
                'message' => 'Archivo eliminado exitosamente'
            ], 200);
        } catch (\Exception $e) {
            return response()->json(['message' => $e->getMessage()], 500);
        }
    }
}
